/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class RhinoBarrelingBruteWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    RhinoBarrelingBruteWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.getManaValue() >= 4) {
            this.set.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((RhinoBarrelingBruteWatcher)game.getState().getWatcher(RhinoBarrelingBruteWatcher.class)).set.contains(source.getControllerId());
    }
}

