/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RhysTheRedeemedEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public RhysTheRedeemedEffect() {
        super(Outcome.Neutral);
        this.staticText = "For each creature token you control, create a token that's a copy of that creature";
    }

    private RhysTheRedeemedEffect(RhysTheRedeemedEffect effect) {
        super((OneShotEffect)effect);
    }

    public RhysTheRedeemedEffect copy() {
        return new RhysTheRedeemedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                if (!permanent.isControlledBy(source.getControllerId())) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

