/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class RhysticScryingEffect
extends OneShotEffect {
    RhysticScryingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if any player pays {2}, discard three cards";
    }

    private RhysticScryingEffect(RhysticScryingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            boolean result = true;
            boolean doEffect = false;
            ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.canRespond() || !cost.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " for " + sourceObject.getLogName() + "?", source, game)) continue;
                cost.clearPaid();
                if (!cost.pay(source, game, source, player.getId(), false, null)) continue;
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " pays the cost for " + sourceObject.getLogName());
                }
                doEffect = true;
                break;
            }
            if (doEffect) {
                controller.discard(3, false, false, source, game);
            }
            return result;
        }
        return false;
    }

    public RhysticScryingEffect copy() {
        return new RhysticScryingEffect(this);
    }
}

