/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PhyrexianMiteToken;

class RiaIvorBaneOfBladeholdEffect
extends PreventionEffectImpl {
    RiaIvorBaneOfBladeholdEffect() {
        super(Duration.EndOfCombat, Integer.MAX_VALUE, true, false);
        this.staticText = "the next time target creature would deal combat damage to one or more players this combat, prevent that damage. If damage is prevented this way, create that many 1/1 colorless Phyrexian Mite artifact creature tokens with toxic 1 and \"This creature can't block.\"";
    }

    private RiaIvorBaneOfBladeholdEffect(RiaIvorBaneOfBladeholdEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        this.used = true;
        this.discard();
        if (preventionData.getPreventedDamage() > 0) {
            PhyrexianMiteToken token = new PhyrexianMiteToken();
            token.putOntoBattlefield(preventionData.getPreventedDamage(), game, source);
        }
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            return targetCreature != null && targetCreature.getId().equals(event.getSourceId());
        }
        return false;
    }

    public RiaIvorBaneOfBladeholdEffect copy() {
        return new RiaIvorBaneOfBladeholdEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }
}

