/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.r.RielleTheEverwiseWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class RielleTheEverwiseTriggeredAbility
extends TriggeredAbilityImpl {
    RielleTheEverwiseTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addWatcher(new RielleTheEverwiseWatcher());
    }

    private RielleTheEverwiseTriggeredAbility(RielleTheEverwiseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARDS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        RielleTheEverwiseWatcher watcher = (RielleTheEverwiseWatcher)game.getState().getWatcher(RielleTheEverwiseWatcher.class);
        if (watcher == null || !watcher.checkDiscarded(event.getPlayerId()) || !event.getPlayerId().equals(this.getControllerId()) || event.getAmount() == 0) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DrawCardSourceControllerEffect(event.getAmount()));
        return true;
    }

    public RielleTheEverwiseTriggeredAbility copy() {
        return new RielleTheEverwiseTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you discard one or more cards for the first time each turn, draw that many cards.";
    }
}

