/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RiftsweeperEffect
extends OneShotEffect {
    RiftsweeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target face-up exiled card. Its owner shuffles it into their library";
    }

    private RiftsweeperEffect(RiftsweeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiftsweeperEffect copy() {
        return new RiftsweeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            card.getCounters(game).clear();
            Player owner = game.getPlayer(card.getOwnerId());
            if (owner != null) {
                return owner.shuffleCardsToLibrary(card, game, source);
            }
        }
        return false;
    }
}

