/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class RipplesOfPotentialWatcher
extends Watcher {
    private final Set<MageObjectReference> proliferatedPermanents = new HashSet<MageObjectReference>();

    RipplesOfPotentialWatcher() {
        super(WatcherScope.CARD);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COUNTER_ADDED) {
            MageObjectReference mor = new MageObjectReference(event.getTargetId(), game);
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (this.sourceId.equals(event.getSourceId()) && permanent != null) {
                this.proliferatedPermanents.add(mor);
            }
        }
    }

    public void reset() {
        super.reset();
        this.proliferatedPermanents.clear();
    }

    Set<MageObjectReference> getProliferatedPermanents() {
        return this.proliferatedPermanents;
    }
}

