/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class RiseEffect
extends OneShotEffect {
    RiseEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target creature card from a graveyard and target creature on the battlefield to their owners' hands";
    }

    private RiseEffect(RiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiseEffect copy() {
        return new RiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cardsToHand = new CardsImpl();
        Card cardInGraveyard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (cardInGraveyard != null) {
            cardsToHand.add(cardInGraveyard);
        }
        if ((permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            cardsToHand.add((Card)permanent);
        }
        controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        return true;
    }
}

