/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.r.RiskyMoveCreatureGainControlEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RiskyMoveFlipCoinEffect
extends OneShotEffect {
    RiskyMoveFlipCoinEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose a creature you control and an opponent. Flip a coin. If you lose the flip, that opponent gains control of that creature";
    }

    private RiskyMoveFlipCoinEffect(RiskyMoveFlipCoinEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiskyMoveFlipCoinEffect copy() {
        return new RiskyMoveFlipCoinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetImpl target1 = new TargetControlledCreaturePermanent().withNotTarget(true);
            TargetOpponent target2 = new TargetOpponent(true);
            if (target1.canChoose(controller.getId(), source, game)) {
                while (!target1.isChosen(game) && target1.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target1, source, game);
                }
            }
            if (target2.canChoose(controller.getId(), source, game)) {
                while (!target2.isChosen(game) && target2.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target2, source, game);
                }
            }
            Permanent permanent = game.getPermanent(target1.getFirstTarget());
            Player chosenOpponent = game.getPlayer(target2.getFirstTarget());
            if (!controller.flipCoin(source, game, true) && permanent != null && chosenOpponent != null) {
                RiskyMoveCreatureGainControlEffect effect = new RiskyMoveCreatureGainControlEffect(Duration.EndOfGame, chosenOpponent.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(chosenOpponent.getLogName() + " has gained control of " + permanent.getLogName());
                return true;
            }
        }
        return false;
    }
}

