/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class RiteOfRuinEffect
extends OneShotEffect {
    RiteOfRuinEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Choose an order for artifacts, creatures, and lands. Each player sacrifices one permanent of the first type, sacrifices two of the second type, then sacrifices three of the third type";
    }

    private RiteOfRuinEffect(RiteOfRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiteOfRuinEffect copy() {
        return new RiteOfRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        choices.add("Artifacts");
        choices.add("Creatures");
        choices.add("Lands");
        LinkedList<CardType> order = new LinkedList<CardType>();
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose a card type");
        choice.setChoices(choices);
        while (choices.size() > 1) {
            if (!controller.choose(Outcome.Sacrifice, (Choice)choice, game)) {
                return false;
            }
            order.add(this.getCardType(choice.getChoice()));
            choices.remove(choice.getChoice());
            choice.clearChoice();
        }
        order.add(this.getCardType((String)choices.iterator().next()));
        int count = 1;
        for (CardType cardType : order) {
            FilterControlledPermanent filter = new FilterControlledPermanent(cardType + " you control");
            filter.add((Predicate)cardType.getPredicate());
            new SacrificeAllEffect(count, (FilterPermanent)filter).apply(game, source);
            ++count;
        }
        return true;
    }

    private CardType getCardType(String type) {
        if ("Artifacts".equals(type)) {
            return CardType.ARTIFACT;
        }
        if ("Creatures".equals(type)) {
            return CardType.CREATURE;
        }
        if ("Lands".equals(type)) {
            return CardType.LAND;
        }
        return null;
    }
}

