/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RitesOfRefusalEffect
extends OneShotEffect {
    RitesOfRefusalEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Discard any number of cards. Counter target spell unless its controller pays {3} for each card discarded this way";
    }

    private RitesOfRefusalEffect(RitesOfRefusalEffect effect) {
        super((OneShotEffect)effect);
    }

    public RitesOfRefusalEffect copy() {
        return new RitesOfRefusalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int count = controller.discard(0, Integer.MAX_VALUE, false, source, game).size();
        return new CounterUnlessPaysEffect((Cost)new GenericManaCost(3 * count)).apply(game, source);
    }
}

