/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RivalryTriggeredAbility
extends TriggeredAbilityImpl {
    public RivalryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2), false);
    }

    private RivalryTriggeredAbility(RivalryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RivalryTriggeredAbility copy() {
        return new RivalryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getTargets().isEmpty()) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
        }
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        UUID player = game.getActivePlayerId();
        int land = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, player, game);
        if (player != null) {
            for (UUID opponent : game.getOpponents(player)) {
                if (land > game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, opponent, game)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "At the beginning of each player's upkeep, if that player controls more lands than each other player, {this} deals 2 damage to them.";
    }
}

