/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RiverchurnMonumentEffect
extends OneShotEffect {
    public RiverchurnMonumentEffect() {
        super(Outcome.Detriment);
        this.staticText = "Any number of target players each mill cards equal to the number of cards in their graveyard.";
    }

    public RiverchurnMonumentEffect(RiverchurnMonumentEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiverchurnMonumentEffect copy() {
        return new RiverchurnMonumentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.millCards(player.getGraveyard().size(), source, game);
        }
        return true;
    }
}

