/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RiversRebukeReturnToHandEffect
extends OneShotEffect {
    RiversRebukeReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all nonland permanents target player controls to their owner's hand";
    }

    private RiversRebukeReturnToHandEffect(RiversRebukeReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, source.getFirstTarget(), source, game).stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }

    public RiversRebukeReturnToHandEffect copy() {
        return new RiversRebukeReturnToHandEffect(this);
    }
}

