/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RoadOfReturnEffect
extends OneShotEffect {
    RoadOfReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put your commander into your hand from the command zone.";
    }

    private RoadOfReturnEffect(RoadOfReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoadOfReturnEffect copy() {
        return new RoadOfReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList commandersInCommandZone = new ArrayList(game.getCommanderCardsFromCommandZone(controller, CommanderCardType.COMMANDER_OR_OATHBREAKER));
        if (commandersInCommandZone.size() == 1) {
            controller.moveCards((Card)commandersInCommandZone.get(0), Zone.HAND, source, game);
        } else if (commandersInCommandZone.size() == 2) {
            Card firstCommander = (Card)commandersInCommandZone.get(0);
            Card secondCommander = (Card)commandersInCommandZone.get(1);
            if (controller.chooseUse(Outcome.ReturnToHand, "Return which commander to hand?", null, firstCommander.getName(), secondCommander.getName(), source, game)) {
                controller.moveCards(firstCommander, Zone.HAND, source, game);
            } else {
                controller.moveCards(secondCommander, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

