/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class RoadsideBlowout
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a permanent with mana value 1");
    private static final FilterPermanent filter2 = new FilterPermanent("creature or Vehicle an opponent controls");
    private static final Condition condition;

    public RoadsideBlowout(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{U}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, condition).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true));
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter2));
        this.getSpellAbility().addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy("<br>"));
    }

    private RoadsideBlowout(RoadsideBlowout card) {
        super((CardImpl)card);
    }

    public RoadsideBlowout copy() {
        return new RoadsideBlowout(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, 1));
        filter2.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        filter2.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        condition = new SourceTargetsPermanentCondition(filter);
    }
}

