/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RoarOfEndlessSongEffect
extends OneShotEffect {
    RoarOfEndlessSongEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power and toughness of each creature you control until end of turn";
    }

    private RoarOfEndlessSongEffect(RoarOfEndlessSongEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoarOfEndlessSongEffect copy() {
        return new RoarOfEndlessSongEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            game.addEffect(new BoostTargetEffect(permanent.getPower().getValue(), permanent.getToughness().getValue()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

