/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RoarOfReclamationEffect
extends OneShotEffect {
    RoarOfReclamationEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player returns all artifact cards from their graveyard to the battlefield";
    }

    private RoarOfReclamationEffect(RoarOfReclamationEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoarOfReclamationEffect copy() {
        return new RoarOfReclamationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.moveCards(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game), Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

