/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.r.RodOfAbsorptionTracker;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RodOfAbsorptionCastEffect
extends OneShotEffect {
    RodOfAbsorptionCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast any number of spells from among cards exiled with {this} with total mana value X or less without paying their mana costs";
    }

    private RodOfAbsorptionCastEffect(RodOfAbsorptionCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public RodOfAbsorptionCastEffect copy() {
        return new RodOfAbsorptionCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)exileZone);
        if (player == null || cards.isEmpty()) {
            return false;
        }
        CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD, (int)Integer.MAX_VALUE, (CardUtil.SpellCastTracker)new RodOfAbsorptionTracker((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)));
        return true;
    }
}

