/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RookieMistakeEffect
extends OneShotEffect {
    RookieMistakeEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "until end of turn, target creature gets +0/+2 and another target creature gets -2/-0";
    }

    private RookieMistakeEffect(RookieMistakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RookieMistakeEffect copy() {
        return new RookieMistakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        BoostTargetEffect effect;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            effect = new BoostTargetEffect(0, 2, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        if ((permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            effect = new BoostTargetEffect(-2, 0, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

