/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;

class RootingMolochMayPlayEffect
extends AsThoughEffectImpl {
    private int castOnTurn = 0;

    RootingMolochMayPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "Until the end of your next turn, you may play that card.";
    }

    private RootingMolochMayPlayEffect(RootingMolochMayPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.castOnTurn = effect.castOnTurn;
    }

    public RootingMolochMayPlayEffect copy() {
        return new RootingMolochMayPlayEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.castOnTurn = game.getTurnNum();
    }

    public boolean isInactive(Ability source, Game game) {
        if (this.castOnTurn != game.getTurnNum() && game.getPhase().getStep().getType() == PhaseStep.END_TURN) {
            return game.isActivePlayer(source.getControllerId());
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return source.isControlledBy(affectedControllerId) && this.getTargetPointer().getTargets(game, source).contains(sourceId);
    }
}

