/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.common.FilterPermanentOrSuspendedCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;

enum RoseTylerValue implements DynamicValue
{
    instance;

    private static final FilterPermanentOrSuspendedCard filter;
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return game.getBattlefield().count(filter.getPermanentFilter(), sourceAbility.getControllerId(), sourceAbility, game) + game.getExile().getCardsOwned(game, sourceAbility.getControllerId()).stream().filter(card -> card.isOwnedBy(sourceAbility.getControllerId())).mapToInt(card -> filter.getCardFilter().match(card, game) ? 1 : 0).sum();
    }

    public RoseTylerValue copy() {
        return this;
    }

    public String getMessage() {
        return "suspended card you own and each other permanent you control with a time counter on it";
    }

    public String toString() {
        return "";
    }

    static {
        filter = new FilterPermanentOrSuspendedCard();
        filter.getPermanentFilter().add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.getPermanentFilter().add((Predicate)CounterType.TIME.getPredicate());
        filter.getPermanentFilter().add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        hint = new ValueHint("Suspended cards you own and other permanents you control with time counters on them", (DynamicValue)instance);
    }
}

