/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.r.RosheenRoaringProphetManaBuilder;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.VariableManaCostPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class RosheenRoaringProphetManaEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder = new RosheenRoaringProphetManaBuilder();
    private static final FilterCard filter = new FilterCard("a card with {X} in its mana cost");

    RosheenRoaringProphetManaEffect() {
        this.staticText = "reveal any number of cards with {X} in their mana cost in your hand. Add {C}{C} for each card revealed this way. Spend this mana only on costs that contain {X}";
    }

    private RosheenRoaringProphetManaEffect(RosheenRoaringProphetManaEffect effect) {
        super((ManaEffect)effect);
    }

    public RosheenRoaringProphetManaEffect copy() {
        return new RosheenRoaringProphetManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int maxAmount;
        Player controller;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (controller = this.getPlayer(game, source)) != null && (maxAmount = controller.getHand().count(filter, game)) > 0) {
            netMana.add((Mana)this.manaBuilder.setMana(Mana.ColorlessMana((int)(2 * maxAmount)), source, game).build(new Object[0]));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        TargetCardInHand target;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = this.getPlayer(game, source);
        if (controller == null) {
            return mana;
        }
        int maxAmount = controller.getHand().count(filter, game);
        if (maxAmount > 0 && controller.choose(Outcome.Benefit, (Target)(target = new TargetCardInHand(0, Integer.MAX_VALUE, filter)), source, game)) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            controller.revealCards(source, (Cards)cards, game);
            return (Mana)this.manaBuilder.setMana(Mana.ColorlessMana((int)(target.getTargets().size() * 2)), source, game).build(new Object[0]);
        }
        return mana;
    }

    static {
        filter.add((Predicate)VariableManaCostPredicate.instance);
    }
}

