/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardSetInfo;
import mage.cards.SplitCard;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;

public final class RoughTumble
extends SplitCard {
    private static final FilterCreaturePermanent filterWithoutFlying = new FilterCreaturePermanent("creature without flying");

    public RoughTumble(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{R}", "{5}{R}", SpellAbilityType.SPLIT);
        DamageAllEffect effect = new DamageAllEffect(2, (FilterPermanent)filterWithoutFlying);
        effect.setText("{this} deals 2 damage to each creature without flying");
        this.getLeftHalfCard().getSpellAbility().addEffect((Effect)effect);
        effect = new DamageAllEffect(6, (FilterPermanent)StaticFilters.FILTER_CREATURE_FLYING);
        effect.setText("{this} deals 6 damage to each creature with flying");
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)effect);
    }

    private RoughTumble(RoughTumble card) {
        super((SplitCard)card);
    }

    public RoughTumble copy() {
        return new RoughTumble(this);
    }

    static {
        filterWithoutFlying.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

