/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RousingRefrainEffect
extends OneShotEffect {
    RousingRefrainEffect() {
        super(Outcome.Benefit);
        this.staticText = "Add {R} for each card in target opponent's hand. Until end of turn, you don't lose this mana as steps and phases end";
    }

    private RousingRefrainEffect(RousingRefrainEffect effect) {
        super((OneShotEffect)effect);
    }

    public RousingRefrainEffect copy() {
        return new RousingRefrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null || player.getHand().isEmpty()) {
            return false;
        }
        controller.getManaPool().addMana(new Mana(ManaType.RED, player.getHand().size()), game, source, true);
        return true;
    }
}

