/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.LoyaltyAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RowansTalentTriggeredAbility
extends TriggeredAbilityImpl {
    RowansTalentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyStackObjectEffect());
        this.setTriggerPhrase("Whenever you activate a loyalty ability of enchanted planeswalker, ");
    }

    private RowansTalentTriggeredAbility(RowansTalentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RowansTalentTriggeredAbility copy() {
        return new RowansTalentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !event.getSourceId().equals(permanent.getAttachedTo()) || !this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null || !(stackObject.getStackAbility() instanceof LoyaltyAbility)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }
}

