/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RoyalDecreeAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterPermanent("a Swamp, Mountain, black permanent, or red permanent");

    public RoyalDecreeAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1));
    }

    private RoyalDecreeAbility(RoyalDecreeAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RoyalDecreeAbility copy() {
        return new RoyalDecreeAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && filter.match(permanent, this.getControllerId(), (Ability)this, game) && (player = game.getPlayer(permanent.getControllerId())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a Swamp, Mountain, black permanent, or red permanent becomes tapped, {this} deals 1 damage to that permanent's controller.";
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.SWAMP.getPredicate(), SubType.MOUNTAIN.getPredicate(), new ColorPredicate(ObjectColor.BLACK), new ColorPredicate(ObjectColor.RED)}));
    }
}

