/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.SpellsCastWatcher;

class RugOfSmotheringEffect
extends OneShotEffect {
    RugOfSmotheringEffect() {
        super(Outcome.Benefit);
        this.staticText = "they lose 1 life for each spell they've cast this turn";
    }

    private RugOfSmotheringEffect(RugOfSmotheringEffect effect) {
        super((OneShotEffect)effect);
    }

    public RugOfSmotheringEffect copy() {
        return new RugOfSmotheringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = ((SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)).getSpellsCastThisTurn(player.getId()).size();
        return count > 0 && player.loseLife(count, game, source, false) > 0;
    }
}

