/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.KickerAbility;
import mage.cards.r.RumblingAftershocksDealDamageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class RumblingAftershocksTriggeredAbility
extends TriggeredAbilityImpl {
    RumblingAftershocksTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RumblingAftershocksDealDamageEffect(), true);
        this.setTriggerPhrase("Whenever you cast a kicked spell, ");
    }

    private RumblingAftershocksTriggeredAbility(RumblingAftershocksTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RumblingAftershocksTriggeredAbility copy() {
        return new RumblingAftershocksTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int kickedCount;
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && (kickedCount = KickerAbility.getKickedCounter((Game)game, (Ability)spell.getSpellAbility())) > 0) {
            ((Effect)this.getEffects().get(0)).setValue("damageAmount", (Object)kickedCount);
            return true;
        }
        return false;
    }
}

