/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class RunedHaloSetProtectionEffect
extends OneShotEffect {
    RunedHaloSetProtectionEffect() {
        super(Outcome.Protect);
        this.staticText = "<br/><br/>You have protection from the chosen card name. <i>(You can't be targeted, dealt damage, or enchanted by anything with that name.)</i>";
    }

    private RunedHaloSetProtectionEffect(RunedHaloSetProtectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (controller != null && cardName != null && !cardName.isEmpty()) {
            FilterObject filter = new FilterObject("the card name [" + cardName + ']');
            filter.add((Predicate)new NamePredicate(cardName));
            GainAbilityControllerEffect effect = new GainAbilityControllerEffect((Ability)new ProtectionAbility((Filter)filter), Duration.Custom);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public RunedHaloSetProtectionEffect copy() {
        return new RunedHaloSetProtectionEffect(this);
    }
}

