/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class RuthlessInstincts
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("nonattacking creature");
    private static final FilterCreaturePermanent filterAttacking = new FilterCreaturePermanent("attacking creature");

    public RuthlessInstincts(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{G}");
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)ReachAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("Target nonattacking creature gains reach");
        this.getSpellAbility().addEffect((Effect)effect);
        effect = new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and deathtouch until end of turn");
        this.getSpellAbility().addEffect((Effect)effect);
        effect = new UntapTargetEffect();
        effect.setText("Untap it");
        this.getSpellAbility().addEffect((Effect)effect);
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        this.getSpellAbility().addTarget((Target)target);
        effect = new BoostTargetEffect(2, 2, Duration.EndOfTurn);
        effect.setText("Target attacking creature gets +2/+2");
        Mode mode = new Mode((Effect)effect);
        effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and gains trample until end of turn");
        mode.addEffect((Effect)effect);
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filterAttacking));
        this.getSpellAbility().addMode(mode);
    }

    private RuthlessInstincts(RuthlessInstincts card) {
        super((CardImpl)card);
    }

    public RuthlessInstincts copy() {
        return new RuthlessInstincts(this);
    }

    static {
        filter.add(Predicates.not((Predicate)AttackingPredicate.instance));
        filterAttacking.add((Predicate)AttackingPredicate.instance);
    }
}

