/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class AttackedOrBlockedSinceYourLastUpkeepWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> attackedOrBlockedCreatures = new HashMap<UUID, Set<MageObjectReference>>();

    public AttackedOrBlockedSinceYourLastUpkeepWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.UPKEEP_STEP_POST) {
            this.attackedOrBlockedCreatures.put(event.getPlayerId(), new HashSet());
        } else if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED || event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            MageObjectReference mor = new MageObjectReference(event.getSourceId(), game);
            for (UUID player : game.getPlayerList()) {
                if (!this.attackedOrBlockedCreatures.containsKey(player)) {
                    this.attackedOrBlockedCreatures.put(player, new HashSet());
                }
                this.attackedOrBlockedCreatures.get(player).add(mor);
            }
        }
    }

    public boolean attackedSinceLastUpkeep(MageObjectReference mor, UUID upkeepPlayer) {
        return this.attackedOrBlockedCreatures.get(upkeepPlayer).contains(mor);
    }
}

