/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlaneswalker;

class DeadlyVanityEffect
extends OneShotEffect {
    DeadlyVanityEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature or planeswalker, then destroy all other creatures and planeswalkers";
    }

    private DeadlyVanityEffect(DeadlyVanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCreatureOrPlaneswalker target = new TargetCreatureOrPlaneswalker();
        target.withNotTarget(true);
        controller.choose(this.outcome, (Target)target, source, game);
        FilterCreatureOrPlaneswalkerPermanent filter = new FilterCreatureOrPlaneswalkerPermanent();
        UUID targetId = target.getFirstTarget();
        if (targetId != null) {
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(targetId)));
        }
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }

    public DeadlyVanityEffect copy() {
        return new DeadlyVanityEffect(this);
    }
}

