/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.DealtDamageToSourceTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PhyrexianModeEffect
extends OneShotEffect {
    PhyrexianModeEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a Phyrexian. It gets +3/+2 and gains trample and \"Whenever this creature is dealt damage, sacrifice that many permanents.\"";
    }

    private PhyrexianModeEffect(PhyrexianModeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianModeEffect copy() {
        return new PhyrexianModeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.WhileOnBattlefield, new SubType[]{SubType.PHYREXIAN}), source);
        game.addEffect((ContinuousEffect)new BoostSourceEffect(3, 2, Duration.WhileOnBattlefield), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.WhileOnBattlefield), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new DealtDamageToSourceTriggeredAbility((Effect)new SacrificeControllerEffect(StaticFilters.FILTER_PERMANENTS, (DynamicValue)SavedDamageValue.MANY, ""), false), Duration.WhileOnBattlefield), source);
        return true;
    }
}

