/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class SacellumGodspeakerEffect
extends ManaEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature cards with power 5 or greater from your hand");

    public SacellumGodspeakerEffect() {
        this.staticText = "Reveal any number of creature cards with power 5 or greater from your hand. Add {G} for each card revealed this way";
    }

    private SacellumGodspeakerEffect(SacellumGodspeakerEffect effect) {
        super((ManaEffect)effect);
    }

    public SacellumGodspeakerEffect copy() {
        return new SacellumGodspeakerEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int count;
        Player controller;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (controller = game.getPlayer(source.getControllerId())) != null && (count = controller.getHand().count((FilterCard)filter, game)) > 0) {
            netMana.add(Mana.GreenMana((int)count));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        TargetCardInHand target;
        Player controller;
        if (game != null && (controller = game.getPlayer(source.getControllerId())) != null && (target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)filter)).choose(Outcome.Benefit, source.getControllerId(), source.getSourceId(), source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl((Collection)target.getTargets()), game);
            return Mana.GreenMana((int)target.getTargets().size());
        }
        return new Mana();
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 4));
    }
}

