/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class SaheeliSublimeArtificerEffect
extends OneShotEffect {
    SaheeliSublimeArtificerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target artifact you control becomes a copy of another target artifact or creature you control until end of turn, except it's an artifact in addition to its other types.";
    }

    private SaheeliSublimeArtificerEffect(SaheeliSublimeArtificerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaheeliSublimeArtificerEffect copy() {
        return new SaheeliSublimeArtificerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyFrom;
        Permanent copyTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (copyTo != null && (copyFrom = game.getPermanentOrLKIBattlefield(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            game.copyPermanent(Duration.EndOfTurn, copyFrom, copyTo.getId(), source, (CopyApplier)new EmptyCopyApplier());
            AddCardTypeTargetEffect effect = new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT});
            effect.setTargetPointer((TargetPointer)new FixedTarget(copyTo, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

