/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.CastSpellLastTurnWatcher;

class SaheeliTheGiftedCostReductionEffect
extends CostModificationEffectImpl {
    private int spellsCast;

    public SaheeliTheGiftedCostReductionEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next spell you cast this turn costs {1} less to cast for each artifact you control as you cast it";
    }

    protected SaheeliTheGiftedCostReductionEffect(SaheeliTheGiftedCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId());
        }
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int artifactCount = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_AN, source.getControllerId(), game).size();
        CardUtil.reduceCost((Ability)abilityToModify, (int)artifactCount);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (abilityToModify instanceof SpellAbility) {
            return abilityToModify.isControlledBy(source.getControllerId());
        }
        return false;
    }

    public SaheeliTheGiftedCostReductionEffect copy() {
        return new SaheeliTheGiftedCostReductionEffect(this);
    }
}

