/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.Mana;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.AddManaToManaPoolTargetControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SakikoMotherOfSummerTriggeredAbility
extends TriggeredAbilityImpl {
    public SakikoMotherOfSummerTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private SakikoMotherOfSummerTriggeredAbility(SakikoMotherOfSummerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SakikoMotherOfSummerTriggeredAbility copy() {
        return new SakikoMotherOfSummerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        if (((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanent(event.getSourceId())) != null && creature.isControlledBy(this.controllerId)) {
            this.getEffects().clear();
            AddManaToManaPoolTargetControllerEffect effect = new AddManaToManaPoolTargetControllerEffect(Mana.GreenMana((int)event.getAmount()), "that player", true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getControllerId()));
            effect.setText("add that much {G}. Until end of turn, you don't lose this mana as steps and phases end");
            this.addEffect((Effect)effect);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control deals combat damage to a player, add that much {G}. Until end of turn, you don't lose this mana as steps and phases end.";
    }
}

