/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SalvationSwanTargetEffect
extends OneShotEffect {
    SalvationSwanTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target creature you control without flying. Return it to the battlefield under its owner's control with a flying counter on it at the beginning of the next end step";
    }

    private SalvationSwanTargetEffect(SalvationSwanTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public SalvationSwanTargetEffect copy() {
        return new SalvationSwanTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        MageObject sourceObject = source.getSourceObject(game);
        if (permanent == null || sourceObject == null) {
            return false;
        }
        ExileZone tempExileZone = game.getExile().createZone(UUID.randomUUID(), "temp");
        permanent.moveToExile(tempExileZone.getId(), tempExileZone.getName(), source, game);
        CardsImpl cardsToReturn = new CardsImpl(tempExileZone.getCards(game));
        cardsToReturn.retainZone(Zone.EXILED, game);
        ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlWithCounterTargetEffect(CounterType.FLYING.createInstance(), true);
        effect.setTargetPointer((TargetPointer)new FixedTargets((Collection)cardsToReturn.getCards(game), game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        String exileKey = "SalvationSwanExile_" + source.getSourceId() + "_" + source.getStackMomentSourceZCC();
        ExileZone sharedExileZone = game.getExile().createZone(CardUtil.getExileZoneId((String)exileKey, (Game)game), sourceObject.getIdName());
        sharedExileZone.setCleanupOnEndTurn(true);
        tempExileZone.getCards(game).forEach(card -> game.getState().getExile().moveToAnotherZone(card, game, sharedExileZone));
        return true;
    }
}

