/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SameNameAsExiledCountValue
implements DynamicValue {
    private static final SameNameAsExiledCountValue instance = new SameNameAsExiledCountValue();

    public static SameNameAsExiledCountValue getInstance() {
        return instance;
    }

    private SameNameAsExiledCountValue() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int value = 0;
        Permanent permanent = game.getPermanent(sourceAbility.getSourceId());
        if (permanent != null && !permanent.getImprinted().isEmpty()) {
            FilterPermanent filterPermanent = new FilterPermanent();
            filterPermanent.add((Predicate)new NamePredicate(game.getCard((UUID)permanent.getImprinted().get(0)).getName()));
            value = game.getBattlefield().count(filterPermanent, sourceAbility.getControllerId(), sourceAbility, game);
        }
        return value;
    }

    public DynamicValue copy() {
        return instance;
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return "land on the battlefield with the same name as the exiled card";
    }
}

