/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SamiteCenserBearerEffect
extends OneShotEffect {
    SamiteCenserBearerEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "Prevent the next 1 damage that would be dealt to each creature you control this turn";
    }

    private SamiteCenserBearerEffect(SamiteCenserBearerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SamiteCenserBearerEffect copy() {
        return new SamiteCenserBearerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            PreventDamageToTargetEffect effect = new PreventDamageToTargetEffect(Duration.EndOfTurn, 1);
            List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game);
            for (Permanent permanent : permanents) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

