/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class SamitePilgrimPreventDamageToTargetEffect
extends PreventionEffectImpl {
    SamitePilgrimPreventDamageToTargetEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, true);
        this.staticText = "Prevent the next X damage that would be dealt to target creature this turn, where X is the number of basic land types among lands you control.";
    }

    private SamitePilgrimPreventDamageToTargetEffect(SamitePilgrimPreventDamageToTargetEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public SamitePilgrimPreventDamageToTargetEffect copy() {
        return new SamitePilgrimPreventDamageToTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.amountToPrevent = DomainValue.REGULAR.calculate(game, source, (Effect)this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.used && super.applies(event, source, game) && event.getTargetId().equals(source.getFirstTarget());
    }
}

