/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;

public final class SanctuaryRaptor
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent("you control three or more tokens");
    private static final Condition condition;
    private static final Hint hint;

    public SanctuaryRaptor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{3}");
        this.subtype.add((Object)SubType.BIRD);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)FlyingAbility.getInstance());
        TriggeredAbility ability = new AttacksTriggeredAbility((Effect)new BoostSourceEffect(2, 0, Duration.EndOfTurn).setText("{this} gets +2/+0")).withInterveningIf(condition);
        ability.addEffect((Effect)new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn).setText("and gains first strike until end of turn"));
        this.addAbility(ability.addHint(hint));
    }

    private SanctuaryRaptor(SanctuaryRaptor card) {
        super((CardImpl)card);
    }

    public SanctuaryRaptor copy() {
        return new SanctuaryRaptor(this);
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        condition = new PermanentsOnTheBattlefieldCondition(filter, ComparisonType.MORE_THAN, 2);
        hint = new ValueHint("Tokens you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

