/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterCard;
import mage.filter.FilterSpell;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.common.TargetCardInLibrary;

public final class SanctumOfUgin
extends CardImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("colorless creature card");
    private static final FilterSpell filterSpells = new FilterSpell("a colorless spell with mana value 7 or greater");

    public SanctumOfUgin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new ColorlessManaAbility());
        SearchLibraryPutInHandEffect effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary((FilterCard)filter), true);
        effect.setText("search your library for a colorless creature card, reveal it, put it into your hand, then shuffle");
        this.addAbility((Ability)new SpellCastControllerTriggeredAbility((Effect)new DoIfCostPaid((Effect)effect, (Cost)new SacrificeSourceCost()), filterSpells, false));
    }

    private SanctumOfUgin(SanctumOfUgin card) {
        super((CardImpl)card);
    }

    public SanctumOfUgin copy() {
        return new SanctumOfUgin(this);
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
        filterSpells.add((Predicate)ColorlessPredicate.instance);
        filterSpells.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 6));
    }
}

