/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.PlayersAttackedThisTurnWatcher;

class SandswirlWanderglyphCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    SandswirlWanderglyphCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each opponent who attacked you or a planeswalker you control this turn can't cast spells";
    }

    private SandswirlWanderglyphCantCastEffect(SandswirlWanderglyphCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SandswirlWanderglyphCantCastEffect copy() {
        return new SandswirlWanderglyphCantCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.isActivePlayer(event.getPlayerId()) && game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            PlayersAttackedThisTurnWatcher watcher = (PlayersAttackedThisTurnWatcher)game.getState().getWatcher(PlayersAttackedThisTurnWatcher.class);
            return watcher != null && watcher.hasPlayerAttackedPlayerOrControlledPlaneswalker(event.getPlayerId(), source.getControllerId());
        }
        return false;
    }
}

