/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.ChromaSanityGrindingCount;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SanityGrindingEffect
extends OneShotEffect {
    SanityGrindingEffect() {
        super(Outcome.Neutral);
        this.staticText = "<i>Chroma</i> &mdash; Reveal the top ten cards of your library. For each blue mana symbol in the mana costs of the revealed cards, target opponent mills a card. Then put the cards you revealed this way on the bottom of your library in any order";
    }

    private SanityGrindingEffect(SanityGrindingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl revealed = new CardsImpl();
        revealed.addAllCards((Collection)controller.getLibrary().getTopCards(game, 10));
        controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (targetOpponent != null) {
            targetOpponent.millCards(new ChromaSanityGrindingCount((Cards)revealed).calculate(game, source, (Effect)this), source, game);
        }
        return controller.putCardsOnBottomOfLibrary((Cards)revealed, game, source, true);
    }

    public SanityGrindingEffect copy() {
        return new SanityGrindingEffect(this);
    }
}

