/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SarkhanTheMadDragonDamageEffect
extends OneShotEffect {
    private static final String effectText = "Each Dragon creature you control deals damage equal to its power to target player or planeswalker";
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    SarkhanTheMadDragonDamageEffect() {
        super(Outcome.Damage);
        this.staticText = effectText;
    }

    private SarkhanTheMadDragonDamageEffect(SarkhanTheMadDragonDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List dragons = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
        if (dragons != null && !dragons.isEmpty()) {
            for (Permanent dragon : dragons) {
                game.damagePlayerOrPermanent(source.getFirstTarget(), dragon.getPower().getValue(), dragon.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    public SarkhanTheMadDragonDamageEffect copy() {
        return new SarkhanTheMadDragonDamageEffect(this);
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

