/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DragonToken2;
import mage.players.Player;

class SarkhanTheMadSacEffect
extends OneShotEffect {
    private static final String effectText = "Target creature's controller sacrifices it, then that player creates a 5/5 red Dragon creature token with flying";

    SarkhanTheMadSacEffect() {
        super(Outcome.Sacrifice);
        this.staticText = effectText;
    }

    private SarkhanTheMadSacEffect(SarkhanTheMadSacEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getTargets().getFirstTarget());
        if (permanent != null) {
            permanent.sacrifice(source, game);
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                DragonToken2 dragonToken = new DragonToken2();
                dragonToken.putOntoBattlefield(1, game, source, player.getId());
            }
        }
        return false;
    }

    public SarkhanTheMadSacEffect copy() {
        return new SarkhanTheMadSacEffect(this);
    }
}

