/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SarkhanTheMasterlessBecomeDragonEffect
extends ContinuousEffectImpl {
    SarkhanTheMasterlessBecomeDragonEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Until end of turn, each planeswalker you control becomes a 4/4 red Dragon creature and gains flying.";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private SarkhanTheMasterlessBecomeDragonEffect(SarkhanTheMasterlessBecomeDragonEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SarkhanTheMasterlessBecomeDragonEffect copy() {
        return new SarkhanTheMasterlessBecomeDragonEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (permanent == null || !permanent.isPlaneswalker(game)) continue;
            this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean flag = false;
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            if (permanent == null) continue;
            flag = true;
            switch (layer) {
                case TypeChangingEffects_4: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.removeAllCardTypes(game);
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    permanent.removeAllSubTypes(game);
                    permanent.addSubType(game, new SubType[]{SubType.DRAGON});
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(ObjectColor.RED);
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(4);
                    permanent.getToughness().setModifiedBaseValue(4);
                }
            }
        }
        return flag;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

