/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SarkhanTheMasterlessDamageEffect
extends OneShotEffect {
    SarkhanTheMasterlessDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "each Dragon you control deals 1 damage to that creature.";
    }

    private SarkhanTheMasterlessDamageEffect(SarkhanTheMasterlessDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SarkhanTheMasterlessDamageEffect copy() {
        return new SarkhanTheMasterlessDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (permanent == null || !permanent.hasSubtype(SubType.DRAGON, game)) continue;
            creature.damage(1, permanent.getId(), source, game);
        }
        return true;
    }
}

